<?php include '../header.php'; ?>
<?php include '../sidebar.php'; ?>
<?php include '../content.php'; ?>

<h1>Error Line Chart</h1>
<div id="chartContainer"></div>

<?php
    $dataPoints1 = array( 
        array("y" => 3.69, "label" => "Jan" ),
        array("y" => 3.06, "label" => "Feb" ),
        array("y" => 4.08, "label" => "Mar" ),
        array("y" => 4.06, "label" => "Apr" ),
        array("y" => 4.48, "label" => "May" ),
        array("y" => 3.45, "label" => "Jun" ),
        array("y" => 4.17, "label" => "Jul" ),
        array("y" => 4.05, "label" => "Aug" ),
        array("y" => 4.05, "label" => "Sep" ),
        array("y" => 3.50, "label" => "Oct" ),
        array("y" => 4.00, "label" => "Nov" ),
        array("y" => 3.86, "label" => "Dec" )
    );
    
    $dataPoints2 = array( 
        array("y" => array(3.6, 3.8), "label" => "Jan" ),
        array("y" => array(3.0, 3.4), "label" => "Feb" ),
        array("y" => array(3.8, 4.3), "label" => "Mar" ),
        array("y" => array(3.9, 4.2), "label" => "Apr" ),
        array("y" => array(4.3, 4.6), "label" => "May" ),
        array("y" => array(3.3, 3.6), "label" => "Jun" ),
        array("y" => array(4.0, 4.4), "label" => "Jul" ),
        array("y" => array(3.9, 4.3), "label" => "Aug" ),
        array("y" => array(3.8, 4.2), "label" => "Sep" ),
        array("y" => array(3.4, 3.7), "label" => "Oct" ),
        array("y" => array(3.8, 4.2), "label" => "Nov" ),
        array("y" => array(3.7, 4.0), "label" => "Dec" )
    );
?>

<script>
    window.onload = function() {
        var chart = new CanvasJS.Chart("chartContainer", {
            animationEnabled: true,
            title:{
                text: "Predicted Rainfall"
            },
            axisX: {
                interval: 1
            },
            axisY:{
                title: "Precipitation (in inch)",
                suffix: " in"
            },
            toolTip: {
                shared: true
            },
            data: [{
                type: "line",
                name: "Predicted",
                toolTipContent: "<b>{label}</b><br><span style=\"color:#4F81BC\">{name}</span>: {y} in",
                markerType: "none",
                dataPoints: <?php echo json_encode($dataPoints1, JSON_NUMERIC_CHECK); ?>
            },
            {
                type: "error",
                name: "Error Range",
                toolTipContent: "<span style=\"color:#C0504E\">{name}</span>: {y[0]} in - {y[1]} in",
                dataPoints: <?php echo json_encode($dataPoints2, JSON_NUMERIC_CHECK); ?>
            }]
        });
        chart.render();
    }
</script>

<?php include '../footer.php'; ?>